#open "num";;

(* renvoie true si le nombre de Mersenne 2^p - 1 est premier, false sinon *)
let est_premier_mersenne p =
	let mersenne = add_num (num_of_int (- 1)) (power_num (num_of_int 2) (num_of_int p)) in
		let s = ref (num_of_int 4) in
			for i = 1 to p - 2 do
				s := mod_num (add_num (num_of_int (- 2)) (square_num !s)) mersenne
			done;
			eq_num !s (num_of_int 0)
;;

(* exemple 1 : Mersenne n 24 (1971) : 2^19937 - 1 est premier *)
let t1 = sys__time () in
	print_string "patienter...";
	print_newline ();
	let res = est_premier_mersenne 19937 in
		let t2 = sys__time () in
			printf__printf "%b , %0.2f s\n" res (t2 -. t1)
;;

(*
let mersenne p = add_num (num_of_int (- 1)) (power_num (num_of_int 2) (num_of_int p));;
let s = string_of_num (mersenne 19937);;
string_length s;;
*)

